#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class ExternalScoresCreate(APIObject):
    """
    Attributes
    ----------
    dataset_id:str
         The dataset to compute predictions for - must have previously been uploaded.
    model_id:str
         The model to use to make predictions.
    actual_value_column:str [optional]
         Actual value column name that contains actual values to be used for computing scores and insights for unsupervised projects only. This value can be set once for a dataset and cannot be changed.. 
    """
    _converter = t.Dict(
        {
            t.Key("dataset_id"):  t.String(),
            t.Key("model_id"):  t.String(),
            t.Key("actual_value_column", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        dataset_id,
        model_id,
        actual_value_column=None,
    ):
        self.dataset_id = dataset_id
        self.model_id = model_id
        self.actual_value_column = actual_value_column

    def __repr__(self):
        return (
            "ExternalScoresCreate("
            "dataset_id={0.dataset_id}, "
            "model_id={0.model_id}, "
            "actual_value_column={0.actual_value_column}, "
        ).format(self)
