#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.external_scores_list_data_score import ExternalScoresListDataScore

class ExternalScoresListData(APIObject):
    """
    Attributes
    ----------
    actual_value_column:str
         The name of the column with actuals that was used to calculate the scores.
    dataset_id:str
         The datasetId the data comes from.
    model_id:str
         The modelId for the scores.
    project_id:str
         The projectId for the scores.
    scores:[ExternalScoresListDataScore]
         A json array of the computed scores.
    """
    _converter = t.Dict(
        {
            t.Key("actual_value_column"):  t.String(),
            t.Key("dataset_id"):  t.String(),
            t.Key("model_id"):  t.String(),
            t.Key("project_id"):  t.String(),
            t.Key("scores"):  t.List(t.Dict().allow_extra("*")),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        actual_value_column,
        dataset_id,
        model_id,
        project_id,
        scores,
    ):
        self.actual_value_column = actual_value_column
        self.dataset_id = dataset_id
        self.model_id = model_id
        self.project_id = project_id
        self.scores = scores

    def __repr__(self):
        return (
            "ExternalScoresListData("
            "actual_value_column={0.actual_value_column}, "
            "dataset_id={0.dataset_id}, "
            "model_id={0.model_id}, "
            "project_id={0.project_id}, "
            "scores={0.scores}, "
        ).format(self)
