#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class ExternalTSBaselineMetadata(APIObject):
    """
    Attributes
    ----------
    dataset_id:str, none_type
         Catalog version id for external prediction data that can be used as a baseline to calculate new metrics.
    dataset_name:str, none_type
         The name of the timeseries baseline dataset for the project
    """
    _converter = t.Dict(
        {
            t.Key("dataset_id"):  t.String(),
            t.Key("dataset_name"):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        dataset_id,
        dataset_name,
    ):
        self.dataset_id = dataset_id
        self.dataset_name = dataset_name

    def __repr__(self):
        return (
            "ExternalTSBaselineMetadata("
            "dataset_id={0.dataset_id}, "
            "dataset_name={0.dataset_name}, "
        ).format(self)
