#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.backtests import Backtests

class ExternalTSBaselinePayload(APIObject):
    """
    Attributes
    ----------
    catalog_version_id:str
         The version id of the external baseline data item in the AI catalog.
    datetime_partition_column:str
         The date column that will be used as the datetime partition column for the specified project.
    forecast_window_end:int
         For time series projects only. How many timeUnits of the datetimePartitionColumn into the future relative to the forecast point the forecast window should end.
    forecast_window_start:int
         For time series projects only. How many timeUnits of the datetimePartitionColumn into the future relative to the forecast point the forecast window should start.
    target:str
         The selected target of the specified project.
    backtests:[Backtests] [optional]
         An array of the configured backtests.. 
    holdout_end_date:datetime [optional]
         The end date of holdout scoring data.. 
    holdout_start_date:datetime [optional]
         The start date of holdout scoring data.. 
    multiseries_id_columns:[str] [optional]
         An array of column names identifying the multiseries ID column(s)to use to identify series within the data. Must match the multiseries ID column(s) for the specified project. Currently, only one multiseries ID column may be specified.. 
    """
    _converter = t.Dict(
        {
            t.Key("catalog_version_id"):  t.String(),
            t.Key("datetime_partition_column"):  t.String(),
            t.Key("forecast_window_end"):  t.Int(),
            t.Key("forecast_window_start"):  t.Int(),
            t.Key("target"):  t.String(),
            t.Key("backtests", optional=True):  t.List(t.Dict().allow_extra("*")),
            t.Key("holdout_end_date", optional=True):  t.DateTime(),
            t.Key("holdout_start_date", optional=True):  t.DateTime(),
            t.Key("multiseries_id_columns", optional=True):  t.List(t.Dict().allow_extra("*")),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        catalog_version_id,
        datetime_partition_column,
        forecast_window_end,
        forecast_window_start,
        target,
        backtests=None,
        holdout_end_date=None,
        holdout_start_date=None,
        multiseries_id_columns=None,
    ):
        self.catalog_version_id = catalog_version_id
        self.datetime_partition_column = datetime_partition_column
        self.forecast_window_end = forecast_window_end
        self.forecast_window_start = forecast_window_start
        self.target = target
        self.backtests = backtests
        self.holdout_end_date = holdout_end_date
        self.holdout_start_date = holdout_start_date
        self.multiseries_id_columns = multiseries_id_columns

    def __repr__(self):
        return (
            "ExternalTSBaselinePayload("
            "catalog_version_id={0.catalog_version_id}, "
            "datetime_partition_column={0.datetime_partition_column}, "
            "forecast_window_end={0.forecast_window_end}, "
            "forecast_window_start={0.forecast_window_start}, "
            "target={0.target}, "
            "backtests={0.backtests}, "
            "holdout_end_date={0.holdout_end_date}, "
            "holdout_start_date={0.holdout_start_date}, "
            "multiseries_id_columns={0.multiseries_id_columns}, "
        ).format(self)
