#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.per_class_fairness import PerClassFairness

class FairnessInsight(APIObject):
    """
    Attributes
    ----------
    fairness_metric:str
         The fairness metric used to calculate the fairness scores.
    fairness_threshold:float
         Value of the fairness threshold, defined in project options.. defaults to 0.8
    model_id:str
         ID of the model fairness was measured for.
    per_class_fairness:[PerClassFairness]
         An array of calculated fairness scores for each protected feature class.
    protected_feature:str
         Name of the protected feature the fairness calculation is made for.
    prediction_threshold:float [optional]
         Model's prediction threshold used when insight was calculated. ``null`` if prediction threshold is not required for the fairness metric calculations.. 
    """
    _converter = t.Dict(
        {
            t.Key("fairness_metric"):  t.String(),
            t.Key("fairness_threshold"):  t.Float(),
            t.Key("model_id"):  t.String(),
            t.Key("per_class_fairness"):  t.List(t.Dict().allow_extra("*")),
            t.Key("protected_feature"):  t.String(),
            t.Key("prediction_threshold", optional=True):  t.Float(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        fairness_metric,
        fairness_threshold,
        model_id,
        per_class_fairness,
        protected_feature,
        prediction_threshold=None,
    ):
        self.fairness_metric = fairness_metric
        self.fairness_threshold = fairness_threshold
        self.model_id = model_id
        self.per_class_fairness = per_class_fairness
        self.protected_feature = protected_feature
        self.prediction_threshold = prediction_threshold

    def __repr__(self):
        return (
            "FairnessInsight("
            "fairness_metric={0.fairness_metric}, "
            "fairness_threshold={0.fairness_threshold}, "
            "model_id={0.model_id}, "
            "per_class_fairness={0.per_class_fairness}, "
            "protected_feature={0.protected_feature}, "
            "prediction_threshold={0.prediction_threshold}, "
        ).format(self)
