#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class Feature(APIObject):
    """
    Attributes
    ----------
    date_format:str, none_type
         The date format string for how this feature was interpreted.
    feature_type:str, none_type
         Feature type.
    importance:float, none_type
         Numeric measure of the relationship strength between the feature and target (independent of model or other features).
    known_in_advance:bool
         Whether the feature was selected as known in advance in a time-series model, false for non-time-series models.
    name:str
         Feature name.
    """
    _converter = t.Dict(
        {
            t.Key("date_format"):  t.String(),
            t.Key("feature_type"):  t.String(),
            t.Key("importance"):  t.Float(),
            t.Key("known_in_advance"):  t.Bool(),
            t.Key("name"):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        date_format,
        feature_type,
        importance,
        known_in_advance,
        name,
    ):
        self.date_format = date_format
        self.feature_type = feature_type
        self.importance = importance
        self.known_in_advance = known_in_advance
        self.name = name

    def __repr__(self):
        return (
            "Feature("
            "date_format={0.date_format}, "
            "feature_type={0.feature_type}, "
            "importance={0.importance}, "
            "known_in_advance={0.known_in_advance}, "
            "name={0.name}, "
        ).format(self)
