#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class FeatureAssociationDetailsRetrieveControllerResponse(APIObject):
    """
    Attributes
    ----------
    chart_type:str
         Which type of plotting the pair of features gets in the UI, e.g. `SCATTER`
    features:[str]
         The name of `feature1` and `feature2`.
    types:[str]
         The type of `feature1` and `feature2`. Possible values: `CATEGORICAL`, `NUMERIC`.
    values:[[bool, date, datetime, dict, float, int, list, str, none_type]]
         The data triplets for pairwise plotting.
    """
    _converter = t.Dict(
        {
            t.Key("chart_type"):  t.String(),
            t.Key("features"):  t.List(t.Dict().allow_extra("*")),
            t.Key("types"):  t.List(t.Dict().allow_extra("*")),
            t.Key("values"):  t.List(t.Dict().allow_extra("*")),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        chart_type,
        features,
        types,
        values,
    ):
        self.chart_type = chart_type
        self.features = features
        self.types = types
        self.values = values

    def __repr__(self):
        return (
            "FeatureAssociationDetailsRetrieveControllerResponse("
            "chart_type={0.chart_type}, "
            "features={0.features}, "
            "types={0.types}, "
            "values={0.values}, "
        ).format(self)
