#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class FeatureAssociationList(APIObject):
    """
    Attributes
    ----------
    featurelist_id:str
         The featurelist Id.
    has_fam:bool
         Whether Feature Association Matrix is calculated for featurelist.
    title:str
         The name of featurelist.
    """
    _converter = t.Dict(
        {
            t.Key("featurelist_id"):  t.String(),
            t.Key("has_fam"):  t.Bool(),
            t.Key("title"):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        featurelist_id,
        has_fam,
        title,
    ):
        self.featurelist_id = featurelist_id
        self.has_fam = has_fam
        self.title = title

    def __repr__(self):
        return (
            "FeatureAssociationList("
            "featurelist_id={0.featurelist_id}, "
            "has_fam={0.has_fam}, "
            "title={0.title}, "
        ).format(self)
