#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.feature_association_retrieve_features import FeatureAssociationRetrieveFeatures
from datarobot.models.full_api.generated.model.feature_association_retrieve_strengths import FeatureAssociationRetrieveStrengths

class FeatureAssociationRetrieveControllerResponse(APIObject):
    """
    Attributes
    ----------
    features:[FeatureAssociationRetrieveFeatures]
         Metadata for each feature and where it goes in the matrix as structured below.
    strengths:[FeatureAssociationRetrieveStrengths]
         Pairwise statistics for the available features as structured below.
    """
    _converter = t.Dict(
        {
            t.Key("features"):  t.List(t.Dict().allow_extra("*")),
            t.Key("strengths"):  t.List(t.Dict().allow_extra("*")),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        features,
        strengths,
    ):
        self.features = features
        self.strengths = strengths

    def __repr__(self):
        return (
            "FeatureAssociationRetrieveControllerResponse("
            "features={0.features}, "
            "strengths={0.strengths}, "
        ).format(self)
