#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class FeatureAssociationRetrieveFeatures(APIObject):
    """
    Attributes
    ----------
    alphabetic_sort_index:int
         A number representing the alphabetical order of this feature compared to the other features in this dataset.
    cluster_id:int
         The ID of the cluster this feature belongs to.
    cluster_name:str
         The name of cluster.
    cluster_sort_index:int
         A number representing the ordering of the feature across all clusters. Features in the same cluster always have adjacent indices.
    feature:str
         The name of the feature.
    importance_sort_index:int
         A number ranking the importance of this feature compared to the other features in this dataset.
    strength_sort_index:int
         A number ranking the strength of this feature compared to the other features in this dataset.
    """
    _converter = t.Dict(
        {
            t.Key("alphabetic_sort_index"):  t.Int(),
            t.Key("cluster_id"):  t.Int(),
            t.Key("cluster_name"):  t.String(),
            t.Key("cluster_sort_index"):  t.Int(),
            t.Key("feature"):  t.String(),
            t.Key("importance_sort_index"):  t.Int(),
            t.Key("strength_sort_index"):  t.Int(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        alphabetic_sort_index,
        cluster_id,
        cluster_name,
        cluster_sort_index,
        feature,
        importance_sort_index,
        strength_sort_index,
    ):
        self.alphabetic_sort_index = alphabetic_sort_index
        self.cluster_id = cluster_id
        self.cluster_name = cluster_name
        self.cluster_sort_index = cluster_sort_index
        self.feature = feature
        self.importance_sort_index = importance_sort_index
        self.strength_sort_index = strength_sort_index

    def __repr__(self):
        return (
            "FeatureAssociationRetrieveFeatures("
            "alphabetic_sort_index={0.alphabetic_sort_index}, "
            "cluster_id={0.cluster_id}, "
            "cluster_name={0.cluster_name}, "
            "cluster_sort_index={0.cluster_sort_index}, "
            "feature={0.feature}, "
            "importance_sort_index={0.importance_sort_index}, "
            "strength_sort_index={0.strength_sort_index}, "
        ).format(self)
