#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class FeatureAssociationRetrieveStrengths(APIObject):
    """
    Attributes
    ----------
    feature1:str
         The name of the first feature.
    feature2:str
         The name of the second feature.
    statistic:float, none_type
         Feature association statistics for `feature1` and `feature2`. For features with no pairwise statistics available the value is `null`.
    """
    _converter = t.Dict(
        {
            t.Key("feature1"):  t.String(),
            t.Key("feature2"):  t.String(),
            t.Key("statistic"):  t.Float(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        feature1,
        feature2,
        statistic,
    ):
        self.feature1 = feature1
        self.feature2 = feature2
        self.statistic = statistic

    def __repr__(self):
        return (
            "FeatureAssociationRetrieveStrengths("
            "feature1={0.feature1}, "
            "feature2={0.feature2}, "
            "statistic={0.statistic}, "
        ).format(self)
