#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class FeatureDiscoverySettingResponse(APIObject):
    """
    Attributes
    ----------
    description:str
         Description of this feature discovery setting
    family:str
         Family of this feature discovery setting
    name:str
         Name of this feature discovery setting
    setting_type:str
         Type of this feature discovery setting
    value:bool
         Value of this feature discovery setting
    verbose_name:str
         Human readable name of this feature discovery setting
    """
    _converter = t.Dict(
        {
            t.Key("description"):  t.String(),
            t.Key("family"):  t.String(),
            t.Key("name"):  t.String(),
            t.Key("setting_type"):  t.String(),
            t.Key("value"):  t.Bool(),
            t.Key("verbose_name"):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        description,
        family,
        name,
        setting_type,
        value,
        verbose_name,
    ):
        self.description = description
        self.family = family
        self.name = name
        self.setting_type = setting_type
        self.value = value
        self.verbose_name = verbose_name

    def __repr__(self):
        return (
            "FeatureDiscoverySettingResponse("
            "description={0.description}, "
            "family={0.family}, "
            "name={0.name}, "
            "setting_type={0.setting_type}, "
            "value={0.value}, "
            "verbose_name={0.verbose_name}, "
        ).format(self)
