#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.feature_effects import FeatureEffects

class FeatureEffectsResponse(APIObject):
    """
    Attributes
    ----------
    feature_effects:[FeatureEffects]
         Feature Effects computational results for each feature.
    model_id:str
         The model ID
    project_id:str
         The project ID
    source:str
         Models data source.
    """
    _converter = t.Dict(
        {
            t.Key("feature_effects"):  t.List(t.Dict().allow_extra("*")),
            t.Key("model_id"):  t.String(),
            t.Key("project_id"):  t.String(),
            t.Key("source"):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        feature_effects,
        model_id,
        project_id,
        source,
    ):
        self.feature_effects = feature_effects
        self.model_id = model_id
        self.project_id = project_id
        self.source = source

    def __repr__(self):
        return (
            "FeatureEffectsResponse("
            "feature_effects={0.feature_effects}, "
            "model_id={0.model_id}, "
            "project_id={0.project_id}, "
            "source={0.source}, "
        ).format(self)
