#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.partial_dependence import PartialDependence
from datarobot.models.full_api.generated.model.predicted_vs_actual import PredictedVsActual

class FeatureFit(APIObject):
    """
    Attributes
    ----------
    feature_importance_score:float
         Feature importance score.
    feature_name:str
         Name of the feature.
    feature_type:str
         Feature type, either numeric or categorical.
    is_scalable:bool, none_type
         Whether numeric feature values can be reported on a log scale.
    weight_label:str, none_type
         Weight label if weight was configured for the project.
    partial_dependence:PartialDependence [optional]
         
    predicted_vs_actual:PredictedVsActual [optional]
         
    """
    _converter = t.Dict(
        {
            t.Key("feature_importance_score"):  t.Float(),
            t.Key("feature_name"):  t.String(),
            t.Key("feature_type"):  t.String(),
            t.Key("is_scalable"):  t.Bool(),
            t.Key("weight_label"):  t.String(),
            t.Key("partial_dependence", optional=True):  t.Any(),
            t.Key("predicted_vs_actual", optional=True):  t.Any(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        feature_importance_score,
        feature_name,
        feature_type,
        is_scalable,
        weight_label,
        partial_dependence=None,
        predicted_vs_actual=None,
    ):
        self.feature_importance_score = feature_importance_score
        self.feature_name = feature_name
        self.feature_type = feature_type
        self.is_scalable = is_scalable
        self.weight_label = weight_label
        self.partial_dependence = partial_dependence
        self.predicted_vs_actual = predicted_vs_actual

    def __repr__(self):
        return (
            "FeatureFit("
            "feature_importance_score={0.feature_importance_score}, "
            "feature_name={0.feature_name}, "
            "feature_type={0.feature_type}, "
            "is_scalable={0.is_scalable}, "
            "weight_label={0.weight_label}, "
            "partial_dependence={0.partial_dependence}, "
            "predicted_vs_actual={0.predicted_vs_actual}, "
        ).format(self)
