#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class FeatureFlagObject(APIObject):
    """
    Attributes
    ----------
    value:bool
         Value of the feature flag
    ui_label:str [optional]
         String representation of the feature flag. 
    ui_tooltip:str [optional]
         Detailed description of the feature flag. 
    """
    _converter = t.Dict(
        {
            t.Key("value"):  t.Bool(),
            t.Key("ui_label", optional=True):  t.String(),
            t.Key("ui_tooltip", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        value,
        ui_label=None,
        ui_tooltip=None,
    ):
        self.value = value
        self.ui_label = ui_label
        self.ui_tooltip = ui_tooltip

    def __repr__(self):
        return (
            "FeatureFlagObject("
            "value={0.value}, "
            "ui_label={0.ui_label}, "
            "ui_tooltip={0.ui_tooltip}, "
        ).format(self)
