#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class FeatureHistogramPlotResponse(APIObject):
    """
    Attributes
    ----------
    count:float
         number of values in the bin (or weights if project is weighted)
    label:str
         bin start for numerical/uncapped, or string value for categorical. The bin `==Missing==` is created for rows that did not have the feature.
    target:float, none_type
         Average value of the target feature values for the bin. For regression projects, it will be null, if the feature was deemed as low informative or project target has not been selected yet or AIM processing has not finished yet. You can use :http:get:`/api/v2/projects/(projectId)/features/` endpoint to find more about low informative features. For binary classification, the same conditions apply as above, but the value should be treated as the ratio of total positives in the bin to bin's total size (`count`). For multiclass projects the value is always null.
    """
    _converter = t.Dict(
        {
            t.Key("count"):  t.Float(),
            t.Key("label"):  t.String(),
            t.Key("target"):  t.Float(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        count,
        label,
        target,
    ):
        self.count = count
        self.label = label
        self.target = target

    def __repr__(self):
        return (
            "FeatureHistogramPlotResponse("
            "count={0.count}, "
            "label={0.label}, "
            "target={0.target}, "
        ).format(self)
