#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class FeatureImpactItem(APIObject):
    """
    Attributes
    ----------
    feature_name:str
         The name of the feature.
    impact_normalized:float
         The same as `impactUnnormalized`, but normalized such that the highest value is `1`.
    impact_unnormalized:float
         How much worse the error metric score is when making predictions on modified data.
    redundant_with:str, none_type
         Name of feature that has the highest correlation with this feature.
    """
    _converter = t.Dict(
        {
            t.Key("feature_name"):  t.String(),
            t.Key("impact_normalized"):  t.Float(),
            t.Key("impact_unnormalized"):  t.Float(),
            t.Key("redundant_with"):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        feature_name,
        impact_normalized,
        impact_unnormalized,
        redundant_with,
    ):
        self.feature_name = feature_name
        self.impact_normalized = impact_normalized
        self.impact_unnormalized = impact_unnormalized
        self.redundant_with = redundant_with

    def __repr__(self):
        return (
            "FeatureImpactItem("
            "feature_name={0.feature_name}, "
            "impact_normalized={0.impact_normalized}, "
            "impact_unnormalized={0.impact_unnormalized}, "
            "redundant_with={0.redundant_with}, "
        ).format(self)
