#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.feature_impact_item import FeatureImpactItem

class FeatureImpactResponse(APIObject):
    """
    Attributes
    ----------
    count:int
         Number of feature impact records in a given batch.
    feature_impacts:[FeatureImpactItem]
         A list which contains feature impact scores for each feature used by a model. If the model has more than 1000 features, the most important 1000 features are returned.
    next:str, none_type
         URL for the next page of results or `null`.
    previous:str, none_type
         URL for the next page of results or `null`.
    ran_redundancy_detection:bool
         Indicates whether redundant feature identification was run while calculating this feature impact.
    row_count:int, none_type
         The number of rows that was used to calculate feature impact. For the feature impact calculated with the default logic, without specifying the ``rowCount``, we return ``null`` here.
    shap_based:bool
         Indicates whether feature impact was calculated using Shapley values. True when permutation approach is not applicable, for example for the anomaly detection models when the project is unsupervised.
    """
    _converter = t.Dict(
        {
            t.Key("count"):  t.Int(),
            t.Key("feature_impacts"):  t.List(t.Dict().allow_extra("*")),
            t.Key("next"):  t.String(),
            t.Key("previous"):  t.String(),
            t.Key("ran_redundancy_detection"):  t.Bool(),
            t.Key("row_count"):  t.Int(),
            t.Key("shap_based"):  t.Bool(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        count,
        feature_impacts,
        next,
        previous,
        ran_redundancy_detection,
        row_count,
        shap_based,
    ):
        self.count = count
        self.feature_impacts = feature_impacts
        self.next = next
        self.previous = previous
        self.ran_redundancy_detection = ran_redundancy_detection
        self.row_count = row_count
        self.shap_based = shap_based

    def __repr__(self):
        return (
            "FeatureImpactResponse("
            "count={0.count}, "
            "feature_impacts={0.feature_impacts}, "
            "next={0.next}, "
            "previous={0.previous}, "
            "ran_redundancy_detection={0.ran_redundancy_detection}, "
            "row_count={0.row_count}, "
            "shap_based={0.shap_based}, "
        ).format(self)
