#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.feature_lineage_join_table import FeatureLineageJoinTable

class FeatureLineageJoin(APIObject):
    """
    Attributes
    ----------
    join_type:str
         Kind of SQL JOIN applied.. defaults to "left, right", must be one of ["left, right", ]
    left_table:FeatureLineageJoinTable
        
    right_table:FeatureLineageJoinTable
        
    """
    _converter = t.Dict(
        {
            t.Key("join_type"):  t.String(),
            t.Key("left_table"):  t.Any(),
            t.Key("right_table"):  t.Any(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        join_type,
        left_table,
        right_table,
    ):
        self.join_type = join_type
        self.left_table = left_table
        self.right_table = right_table

    def __repr__(self):
        return (
            "FeatureLineageJoin("
            "join_type={0.join_type}, "
            "left_table={0.left_table}, "
            "right_table={0.right_table}, "
        ).format(self)
