#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class FeatureLineageJoinTable(APIObject):
    """
    Attributes
    ----------
    columns:[str]
         List of columns which datasets were joined by.
    datasteps:[int]
         List of *data* steps id which brought the *columns* into the current step dataset.
    """
    _converter = t.Dict(
        {
            t.Key("columns"):  t.List(t.Dict().allow_extra("*")),
            t.Key("datasteps"):  t.List(t.Dict().allow_extra("*")),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        columns,
        datasteps,
    ):
        self.columns = columns
        self.datasteps = datasteps

    def __repr__(self):
        return (
            "FeatureLineageJoinTable("
            "columns={0.columns}, "
            "datasteps={0.datasteps}, "
        ).format(self)
