#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.feature_lineage_join import FeatureLineageJoin
from datarobot.models.full_api.generated.model.feature_lineage_time_info import FeatureLineageTimeInfo

class FeatureLineageStep(APIObject):
    """
    Attributes
    ----------
    id:int
         Step id starting with 0.
    parents:[int]
         `id` of steps which use this step output as their input.
    step_type:str
         One of four types of a step. **data** - source features. **action** - data aggregation or trasformation. **join** - SQL JOIN. **generatedData** - final feature. There is always one **generatedData** step and at least one **data** step.
    arguments:{str: (bool, date, datetime, dict, float, int, list, str, none_type)} [optional]
         Generic key-value pairs to describe **action** step additional parameters.. 
    catalog_id:str [optional]
         id of the catalog for a **data** step.. 
    catalog_version_id:str [optional]
         id of the catalog version for a **data** step.. 
    description:str [optional]
         Description of the step.. 
    group_by:[str] [optional]
         List of columns which this **action** step aggregated.. 
    is_time_aware:bool [optional]
         Indicator of step being time aware. Mandatory only for **action** and **join** steps. **action** step provides additional information about feature derivation window in the `timeInfo` field.. 
    join_info:FeatureLineageJoin [optional]
         
    name:str [optional]
         Name of the step.. 
    time_info:FeatureLineageTimeInfo [optional]
         
    """
    _converter = t.Dict(
        {
            t.Key("id"):  t.Int(),
            t.Key("parents"):  t.List(t.Dict().allow_extra("*")),
            t.Key("step_type"):  t.String(),
            t.Key("arguments", optional=True):  t.Any(),
            t.Key("catalog_id", optional=True):  t.String(),
            t.Key("catalog_version_id", optional=True):  t.String(),
            t.Key("description", optional=True):  t.String(),
            t.Key("group_by", optional=True):  t.List(t.Dict().allow_extra("*")),
            t.Key("is_time_aware", optional=True):  t.Bool(),
            t.Key("join_info", optional=True):  t.Any(),
            t.Key("name", optional=True):  t.String(),
            t.Key("time_info", optional=True):  t.Any(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        id,
        parents,
        step_type,
        arguments=None,
        catalog_id=None,
        catalog_version_id=None,
        description=None,
        group_by=None,
        is_time_aware=None,
        join_info=None,
        name=None,
        time_info=None,
    ):
        self.id = id
        self.parents = parents
        self.step_type = step_type
        self.arguments = arguments
        self.catalog_id = catalog_id
        self.catalog_version_id = catalog_version_id
        self.description = description
        self.group_by = group_by
        self.is_time_aware = is_time_aware
        self.join_info = join_info
        self.name = name
        self.time_info = time_info

    def __repr__(self):
        return (
            "FeatureLineageStep("
            "id={0.id}, "
            "parents={0.parents}, "
            "step_type={0.step_type}, "
            "arguments={0.arguments}, "
            "catalog_id={0.catalog_id}, "
            "catalog_version_id={0.catalog_version_id}, "
            "description={0.description}, "
            "group_by={0.group_by}, "
            "is_time_aware={0.is_time_aware}, "
            "join_info={0.join_info}, "
            "name={0.name}, "
            "time_info={0.time_info}, "
        ).format(self)
