#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class FeatureListCreate(APIObject):
    """
    Attributes
    ----------
    features:[str]
         List of names of features to be included in the new featurelist, all features listed must be part of the universe. All features for this dataset for the request to succeed.
    name:str
         Name of the featurelist to be created
    description:str [optional]
         Description of the featurelist. 
    """
    _converter = t.Dict(
        {
            t.Key("features"):  t.List(t.Dict().allow_extra("*")),
            t.Key("name"):  t.String(),
            t.Key("description", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        features,
        name,
        description=None,
    ):
        self.features = features
        self.name = name
        self.description = description

    def __repr__(self):
        return (
            "FeatureListCreate("
            "features={0.features}, "
            "name={0.name}, "
            "description={0.description}, "
        ).format(self)
