#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class FeatureMetricDetailsResponse(APIObject):
    """
    Attributes
    ----------
    ascending:bool
         Should the metric be sorted in ascending order
    metric_name:str
         Name of the metric
    supports_binary:bool
         This metric is valid for binary classifciaton
    supports_multiclass:bool
         This metric is valid for mutliclass classifciaton
    supports_regression:bool
         This metric is valid for regression
    supports_timeseries:bool
         This metric is valid for timeseries
    """
    _converter = t.Dict(
        {
            t.Key("ascending"):  t.Bool(),
            t.Key("metric_name"):  t.String(),
            t.Key("supports_binary"):  t.Bool(),
            t.Key("supports_multiclass"):  t.Bool(),
            t.Key("supports_regression"):  t.Bool(),
            t.Key("supports_timeseries"):  t.Bool(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        ascending,
        metric_name,
        supports_binary,
        supports_multiclass,
        supports_regression,
        supports_timeseries,
    ):
        self.ascending = ascending
        self.metric_name = metric_name
        self.supports_binary = supports_binary
        self.supports_multiclass = supports_multiclass
        self.supports_regression = supports_regression
        self.supports_timeseries = supports_timeseries

    def __repr__(self):
        return (
            "FeatureMetricDetailsResponse("
            "ascending={0.ascending}, "
            "metric_name={0.metric_name}, "
            "supports_binary={0.supports_binary}, "
            "supports_multiclass={0.supports_multiclass}, "
            "supports_regression={0.supports_regression}, "
            "supports_timeseries={0.supports_timeseries}, "
        ).format(self)
