#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.feature_metric_details_response import FeatureMetricDetailsResponse

class FeatureMetricsResponse(APIObject):
    """
    Attributes
    ----------
    available_metrics:[str]
         an array of strings representing the appropriate metrics.  If the feature cannot be selected as the target, then this array will be empty.
    feature_name:str
         the name of the feature that was looked up
    metric_details:[FeatureMetricDetailsResponse]
         the list of metricDetails objects.
    """
    _converter = t.Dict(
        {
            t.Key("available_metrics"):  t.List(t.Dict().allow_extra("*")),
            t.Key("feature_name"):  t.String(),
            t.Key("metric_details"):  t.List(t.Dict().allow_extra("*")),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        available_metrics,
        feature_name,
        metric_details,
    ):
        self.available_metrics = available_metrics
        self.feature_name = feature_name
        self.metric_details = metric_details

    def __repr__(self):
        return (
            "FeatureMetricsResponse("
            "available_metrics={0.available_metrics}, "
            "feature_name={0.feature_name}, "
            "metric_details={0.metric_details}, "
        ).format(self)
