#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class FeatureSetting(APIObject):
    """
    Attributes
    ----------
    feature_name:str
         The name of the feature being specified.
    a_priori:bool [optional]
         Renamed to `knownInAdvance`.. 
    do_not_derive:bool [optional]
         For time series projects only. Sets whether the feature is do-not-derive, i.e., is excluded from feature derivation. If not specified, the feature uses the value from the `defaultToDoNotDerive` flag.. 
    known_in_advance:bool [optional]
         For time series projects only. Sets whether the feature is known in advance, i.e., values for future dates are known at prediction time. If not specified, the feature uses the value from the `defaultToKnownInAdvance` flag.. 
    """
    _converter = t.Dict(
        {
            t.Key("feature_name"):  t.String(),
            t.Key("a_priori", optional=True):  t.Bool(),
            t.Key("do_not_derive", optional=True):  t.Bool(),
            t.Key("known_in_advance", optional=True):  t.Bool(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        feature_name,
        a_priori=None,
        do_not_derive=None,
        known_in_advance=None,
    ):
        self.feature_name = feature_name
        self.a_priori = a_priori
        self.do_not_derive = do_not_derive
        self.known_in_advance = known_in_advance

    def __repr__(self):
        return (
            "FeatureSetting("
            "feature_name={0.feature_name}, "
            "a_priori={0.a_priori}, "
            "do_not_derive={0.do_not_derive}, "
            "known_in_advance={0.known_in_advance}, "
        ).format(self)
