#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class FeatureTransform(APIObject):
    """
    Attributes
    ----------
    name:str
         The name of the new feature. Must not be the same as any existing features for this project. Must not contain '/' character.
    parent_name:str
         The name of the parent feature.
    variable_type:str
         The type of the new feature. Must be one of `text`, `categorical` (Deprecated in version v2.21), `numeric`, or `categoricalInt`. See the description of this method for more information.
    date_extraction:str [optional]
         The value to extract from the date column, of these options: `[year|yearDay|month|monthDay|week|weekDay]`. Required for transformation of a date column. Otherwise must not be provided.. 
    replacement:bool, date, datetime, dict, float, int, list, str, none_type [optional]
         The replacement in case of a failed transformation.. 
    """
    _converter = t.Dict(
        {
            t.Key("name"):  t.String(),
            t.Key("parent_name"):  t.String(),
            t.Key("variable_type"):  t.String(),
            t.Key("date_extraction", optional=True):  t.String(),
            t.Key("replacement", optional=True):  t.Any(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        name,
        parent_name,
        variable_type,
        date_extraction=None,
        replacement=None,
    ):
        self.name = name
        self.parent_name = parent_name
        self.variable_type = variable_type
        self.date_extraction = date_extraction
        self.replacement = replacement

    def __repr__(self):
        return (
            "FeatureTransform("
            "name={0.name}, "
            "parent_name={0.parent_name}, "
            "variable_type={0.variable_type}, "
            "date_extraction={0.date_extraction}, "
            "replacement={0.replacement}, "
        ).format(self)
