#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class FeaturelistDestroyResponse(APIObject):
    """
    Attributes
    ----------
    can_delete:str
         Whether the featurelist can be deleted.
    deletion_blocked_reason:str
         If the featurelist can't be deleted, this explains why.
    dry_run:str
         Whether this was a dry-run or the featurelist was actually deleted.
    num_affected_jobs:int
         Number of incomplete jobs using this featurelist.
    num_affected_models:int
         Number of models using this featurelist.
    """
    _converter = t.Dict(
        {
            t.Key("can_delete"):  t.String(),
            t.Key("deletion_blocked_reason"):  t.String(),
            t.Key("dry_run"):  t.String(),
            t.Key("num_affected_jobs"):  t.Int(),
            t.Key("num_affected_models"):  t.Int(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        can_delete,
        deletion_blocked_reason,
        dry_run,
        num_affected_jobs,
        num_affected_models,
    ):
        self.can_delete = can_delete
        self.deletion_blocked_reason = deletion_blocked_reason
        self.dry_run = dry_run
        self.num_affected_jobs = num_affected_jobs
        self.num_affected_models = num_affected_models

    def __repr__(self):
        return (
            "FeaturelistDestroyResponse("
            "can_delete={0.can_delete}, "
            "deletion_blocked_reason={0.deletion_blocked_reason}, "
            "dry_run={0.dry_run}, "
            "num_affected_jobs={0.num_affected_jobs}, "
            "num_affected_models={0.num_affected_models}, "
        ).format(self)
