#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class FeaturelistResponse(APIObject):
    """
    Attributes
    ----------
    created:str
         A :ref:`timestamp <time_format>` string specifying when the featurelist was created.
    description:str
         User-friendly description of the featurelist, which can be updated by users.
    features:[str]
         Names of features included in the featurelist.
    id:str
         Featurelist ID.
    is_user_created:bool
         Whether the featurelist was created manually by a user or by DataRobot automation.
    name:str
         the name of the featurelist
    num_models:int
         The number of models that currently use this featurelist. A model is considered to use a featurelist if it is used to train the model or as a monotonic constraint featurelist, or if the model is a blender with at least one component model using the featurelist.
    project_id:str
         Project ID the featurelist belongs to.
    """
    _converter = t.Dict(
        {
            t.Key("created"):  t.String(),
            t.Key("description"):  t.String(),
            t.Key("features"):  t.List(t.Dict().allow_extra("*")),
            t.Key("id"):  t.String(),
            t.Key("is_user_created"):  t.Bool(),
            t.Key("name"):  t.String(),
            t.Key("num_models"):  t.Int(),
            t.Key("project_id"):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        created,
        description,
        features,
        id,
        is_user_created,
        name,
        num_models,
        project_id,
    ):
        self.created = created
        self.description = description
        self.features = features
        self.id = id
        self.is_user_created = is_user_created
        self.name = name
        self.num_models = num_models
        self.project_id = project_id

    def __repr__(self):
        return (
            "FeaturelistResponse("
            "created={0.created}, "
            "description={0.description}, "
            "features={0.features}, "
            "id={0.id}, "
            "is_user_created={0.is_user_created}, "
            "name={0.name}, "
            "num_models={0.num_models}, "
            "project_id={0.project_id}, "
        ).format(self)
