#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.feature_setting import FeatureSetting
from datarobot.models.full_api.generated.model.final_backtest_response import FinalBacktestResponse
from datarobot.models.full_api.generated.model.partitioning_warning import PartitioningWarning
from datarobot.models.full_api.generated.model.periodicity import Periodicity

class FinalDatetimePartitioningResponse(APIObject):
    """
    Attributes
    ----------
    aggregation_type:str, none_type
         For multiseries projects only. The aggregation type to apply when creating cross-series features.
    autopilot_data_selection_method:str
         The Data Selection method to be used by autopilot when creating models for datetime-partitioned datasets.
    available_training_duration:str
         The duration of available training duration for scoring the holdout.
    available_training_end_date:datetime
         The end date of available training data for scoring the holdout.
    available_training_row_count:int
         The number of rows in the available training data for scoring the holdout
    available_training_start_date:datetime
         The start date of available training data for scoring the holdout.
    backtests:[FinalBacktestResponse]
         An array of the configured backtests.
    calendar_id:str, none_type
         The ID of the calendar to be used in this project.
    calendar_name:str, none_type
         The name of the calendar used in this project.
    cross_series_group_by_columns:[str], none_type
         For multiseries projects with cross-series features enabled only. List of columns (currently of length 1). Setting that indicates how to further split series into related groups. For example, if every series is sales of an individual product, the series group-by could be the product category with values like \"men's clothing\", \"sports equipment\", etc.
    date_format:str
         The date format of the partition column.
    datetime_partition_column:str
         The date column that will be used as a datetime partition column.
    default_to_a_priori:bool
         Renamed to `defaultToKnownInAdvance`.
    default_to_do_not_derive:bool
         For time series projects only. Sets whether all features default to being treated as do-not-derive features, excluding them from feature derivation. Individual features can be set to a value different than the default by using the `featureSettings` parameter.
    default_to_known_in_advance:bool
         For time series projects only. Sets whether all features default to being treated as known in advance features, which are features that are known into the future. Features marked as known in advance must be specified into the future when making predictions. The default is false, all features are not known in advance. Individual features can be set to a value different than the default using the `featureSettings` parameter. See the :ref:`Time Series Overview <time_series_overview>` for more context.
    differencing_method:str, none_type
         For time series projects only. Used to specify which differencing method to apply if the data is stationary. For classification problems `simple` and `seasonal` are not allowed. Parameter `periodicities` must be specified if `seasonal` is chosen. Defaults to `auto`.
    disable_holdout:bool
         A boolean value indicating whether date partitioning skipped allocating a holdout fold.
    feature_derivation_window_end:int, none_type
         For time series projects only. How many timeUnits of the datetimePartitionColumn into the past relative to the forecast point the feature derivation window should end.
    feature_derivation_window_start:int, none_type
         For time series projects only. How many timeUnits of the datetimePartitionColumn into the past relative to the forecast point the feature derivation window should begin.
    feature_settings:[FeatureSetting]
         An array specifying per feature settings. Features can be left unspecified.
    forecast_window_end:int, none_type
         For time series projects only. How many timeUnits of the datetimePartitionColumn into the future relative to the forecast point the forecast window should end.
    forecast_window_start:int, none_type
         For time series projects only. How many timeUnits of the datetimePartitionColumn into the future relative to the forecast point the forecast window should start.
    gap_duration:str
         The duration of the gap between the training and holdout scoring data.
    gap_end_date:datetime
         The end date of the gap between the training and holdout scoring data.
    gap_row_count:int
         The number of rows in the gap between the training and holdout scoring data
    gap_start_date:datetime
         The start date of the gap between the training and holdout scoring data.
    holdout_duration:str
         The duration of the holdout scoring data.
    holdout_end_date:datetime
         The end date of holdout scoring data.
    holdout_row_count:int
         The number of rows in the holdout scoring data
    holdout_start_date:datetime
         The start date of holdout scoring data.
    model_splits:int, none_type
         Sets the cap on the number of jobs per model used when building models to control number of jobs in the queue. Higher number of modelSplits will allow for less downsampling leading to the use of more post-processed data. 
    multiseries_id_columns:[str], none_type
         May be used only with time series projects. An array of the column names identifying  the series to which each row of the dataset belongs. Currently only one multiseries ID column is supported. See the :ref:`multiseries <multiseries>` section of the time series documentation for more context.
    number_of_backtests:int
         The number of backtests to use. If omitted, defaults to a positive value selected by the server based on the validation and gap durations.
    number_of_do_not_derive_features:int
         Number of features that are marked as \"do not derive\".
    number_of_known_in_advance_features:int
         Number of features that are marked as \"known in advance\".
    partitioning_warnings:[PartitioningWarning]
         An array of available warnings about potential problems with the chosen partitioning that could cause issues during modeling, although the partitioning may be successfully submitted.
    periodicities:[Periodicity], none_type
         A list of periodicities for time series projects only. For classification problems periodicities are not allowed. If this is provided, parameter 'differencing_method' will default to 'seasonal' if not provided or 'auto'.
    primary_training_duration:str
         The duration of primary training duration for scoring the holdout.
    primary_training_end_date:datetime
         The end date of primary training data for scoring the holdout.
    primary_training_row_count:int
         The number of rows in the primary training data for scoring the holdout
    primary_training_start_date:datetime
         The start date of primary training data for scoring the holdout.
    project_id:str
         The ID of the project.
    total_row_count:int
         The total number of rows in the project dataset
    treat_as_exponential:str, none_type
         For time series projects only. Used to specify whether to treat data as exponential trend and apply transformations like log-transform. For classification problems `always` is not allowed. Defaults to `auto`.
    use_cross_series_features:bool, none_type
         For multiseries projects only. Indicating whether to use cross-series features.
    use_time_series:bool
         A boolean value indicating whether a time series project should be created instead of a regular project which uses datetime partitioning.
    validation_duration:str, none_type
         The default validation duration for all backtests. If the primary date/time feature in a time series project is irregular, you cannot set a default validation length. Instead, set each duration individually.
    windows_basis_unit:str, none_type
         For time series projects only. Indicates which unit is basis for feature derivation window and forecast window. Valid options are detected time unit or `ROW`. If omitted, the default value is detected time unit.
    """
    _converter = t.Dict(
        {
            t.Key("aggregation_type"):  t.String(),
            t.Key("autopilot_data_selection_method"):  t.String(),
            t.Key("available_training_duration"):  t.String(),
            t.Key("available_training_end_date"):  t.DateTime(),
            t.Key("available_training_row_count"):  t.Int(),
            t.Key("available_training_start_date"):  t.DateTime(),
            t.Key("backtests"):  t.List(t.Dict().allow_extra("*")),
            t.Key("calendar_id"):  t.String(),
            t.Key("calendar_name"):  t.String(),
            t.Key("cross_series_group_by_columns"):  t.List(t.Dict().allow_extra("*")),
            t.Key("date_format"):  t.String(),
            t.Key("datetime_partition_column"):  t.String(),
            t.Key("default_to_a_priori"):  t.Bool(),
            t.Key("default_to_do_not_derive"):  t.Bool(),
            t.Key("default_to_known_in_advance"):  t.Bool(),
            t.Key("differencing_method"):  t.String(),
            t.Key("disable_holdout"):  t.Bool(),
            t.Key("feature_derivation_window_end"):  t.Int(),
            t.Key("feature_derivation_window_start"):  t.Int(),
            t.Key("feature_settings"):  t.List(t.Dict().allow_extra("*")),
            t.Key("forecast_window_end"):  t.Int(),
            t.Key("forecast_window_start"):  t.Int(),
            t.Key("gap_duration"):  t.String(),
            t.Key("gap_end_date"):  t.DateTime(),
            t.Key("gap_row_count"):  t.Int(),
            t.Key("gap_start_date"):  t.DateTime(),
            t.Key("holdout_duration"):  t.String(),
            t.Key("holdout_end_date"):  t.DateTime(),
            t.Key("holdout_row_count"):  t.Int(),
            t.Key("holdout_start_date"):  t.DateTime(),
            t.Key("model_splits"):  t.Int(),
            t.Key("multiseries_id_columns"):  t.List(t.Dict().allow_extra("*")),
            t.Key("number_of_backtests"):  t.Int(),
            t.Key("number_of_do_not_derive_features"):  t.Int(),
            t.Key("number_of_known_in_advance_features"):  t.Int(),
            t.Key("partitioning_warnings"):  t.List(t.Dict().allow_extra("*")),
            t.Key("periodicities"):  t.List(t.Dict().allow_extra("*")),
            t.Key("primary_training_duration"):  t.String(),
            t.Key("primary_training_end_date"):  t.DateTime(),
            t.Key("primary_training_row_count"):  t.Int(),
            t.Key("primary_training_start_date"):  t.DateTime(),
            t.Key("project_id"):  t.String(),
            t.Key("total_row_count"):  t.Int(),
            t.Key("treat_as_exponential"):  t.String(),
            t.Key("use_cross_series_features"):  t.Bool(),
            t.Key("use_time_series"):  t.Bool(),
            t.Key("validation_duration"):  t.String(),
            t.Key("windows_basis_unit"):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        aggregation_type,
        autopilot_data_selection_method,
        available_training_duration,
        available_training_end_date,
        available_training_row_count,
        available_training_start_date,
        backtests,
        calendar_id,
        calendar_name,
        cross_series_group_by_columns,
        date_format,
        datetime_partition_column,
        default_to_a_priori,
        default_to_do_not_derive,
        default_to_known_in_advance,
        differencing_method,
        disable_holdout,
        feature_derivation_window_end,
        feature_derivation_window_start,
        feature_settings,
        forecast_window_end,
        forecast_window_start,
        gap_duration,
        gap_end_date,
        gap_row_count,
        gap_start_date,
        holdout_duration,
        holdout_end_date,
        holdout_row_count,
        holdout_start_date,
        model_splits,
        multiseries_id_columns,
        number_of_backtests,
        number_of_do_not_derive_features,
        number_of_known_in_advance_features,
        partitioning_warnings,
        periodicities,
        primary_training_duration,
        primary_training_end_date,
        primary_training_row_count,
        primary_training_start_date,
        project_id,
        total_row_count,
        treat_as_exponential,
        use_cross_series_features,
        use_time_series,
        validation_duration,
        windows_basis_unit,
    ):
        self.aggregation_type = aggregation_type
        self.autopilot_data_selection_method = autopilot_data_selection_method
        self.available_training_duration = available_training_duration
        self.available_training_end_date = available_training_end_date
        self.available_training_row_count = available_training_row_count
        self.available_training_start_date = available_training_start_date
        self.backtests = backtests
        self.calendar_id = calendar_id
        self.calendar_name = calendar_name
        self.cross_series_group_by_columns = cross_series_group_by_columns
        self.date_format = date_format
        self.datetime_partition_column = datetime_partition_column
        self.default_to_a_priori = default_to_a_priori
        self.default_to_do_not_derive = default_to_do_not_derive
        self.default_to_known_in_advance = default_to_known_in_advance
        self.differencing_method = differencing_method
        self.disable_holdout = disable_holdout
        self.feature_derivation_window_end = feature_derivation_window_end
        self.feature_derivation_window_start = feature_derivation_window_start
        self.feature_settings = feature_settings
        self.forecast_window_end = forecast_window_end
        self.forecast_window_start = forecast_window_start
        self.gap_duration = gap_duration
        self.gap_end_date = gap_end_date
        self.gap_row_count = gap_row_count
        self.gap_start_date = gap_start_date
        self.holdout_duration = holdout_duration
        self.holdout_end_date = holdout_end_date
        self.holdout_row_count = holdout_row_count
        self.holdout_start_date = holdout_start_date
        self.model_splits = model_splits
        self.multiseries_id_columns = multiseries_id_columns
        self.number_of_backtests = number_of_backtests
        self.number_of_do_not_derive_features = number_of_do_not_derive_features
        self.number_of_known_in_advance_features = number_of_known_in_advance_features
        self.partitioning_warnings = partitioning_warnings
        self.periodicities = periodicities
        self.primary_training_duration = primary_training_duration
        self.primary_training_end_date = primary_training_end_date
        self.primary_training_row_count = primary_training_row_count
        self.primary_training_start_date = primary_training_start_date
        self.project_id = project_id
        self.total_row_count = total_row_count
        self.treat_as_exponential = treat_as_exponential
        self.use_cross_series_features = use_cross_series_features
        self.use_time_series = use_time_series
        self.validation_duration = validation_duration
        self.windows_basis_unit = windows_basis_unit

    def __repr__(self):
        return (
            "FinalDatetimePartitioningResponse("
            "aggregation_type={0.aggregation_type}, "
            "autopilot_data_selection_method={0.autopilot_data_selection_method}, "
            "available_training_duration={0.available_training_duration}, "
            "available_training_end_date={0.available_training_end_date}, "
            "available_training_row_count={0.available_training_row_count}, "
            "available_training_start_date={0.available_training_start_date}, "
            "backtests={0.backtests}, "
            "calendar_id={0.calendar_id}, "
            "calendar_name={0.calendar_name}, "
            "cross_series_group_by_columns={0.cross_series_group_by_columns}, "
            "date_format={0.date_format}, "
            "datetime_partition_column={0.datetime_partition_column}, "
            "default_to_a_priori={0.default_to_a_priori}, "
            "default_to_do_not_derive={0.default_to_do_not_derive}, "
            "default_to_known_in_advance={0.default_to_known_in_advance}, "
            "differencing_method={0.differencing_method}, "
            "disable_holdout={0.disable_holdout}, "
            "feature_derivation_window_end={0.feature_derivation_window_end}, "
            "feature_derivation_window_start={0.feature_derivation_window_start}, "
            "feature_settings={0.feature_settings}, "
            "forecast_window_end={0.forecast_window_end}, "
            "forecast_window_start={0.forecast_window_start}, "
            "gap_duration={0.gap_duration}, "
            "gap_end_date={0.gap_end_date}, "
            "gap_row_count={0.gap_row_count}, "
            "gap_start_date={0.gap_start_date}, "
            "holdout_duration={0.holdout_duration}, "
            "holdout_end_date={0.holdout_end_date}, "
            "holdout_row_count={0.holdout_row_count}, "
            "holdout_start_date={0.holdout_start_date}, "
            "model_splits={0.model_splits}, "
            "multiseries_id_columns={0.multiseries_id_columns}, "
            "number_of_backtests={0.number_of_backtests}, "
            "number_of_do_not_derive_features={0.number_of_do_not_derive_features}, "
            "number_of_known_in_advance_features={0.number_of_known_in_advance_features}, "
            "partitioning_warnings={0.partitioning_warnings}, "
            "periodicities={0.periodicities}, "
            "primary_training_duration={0.primary_training_duration}, "
            "primary_training_end_date={0.primary_training_end_date}, "
            "primary_training_row_count={0.primary_training_row_count}, "
            "primary_training_start_date={0.primary_training_start_date}, "
            "project_id={0.project_id}, "
            "total_row_count={0.total_row_count}, "
            "treat_as_exponential={0.treat_as_exponential}, "
            "use_cross_series_features={0.use_cross_series_features}, "
            "use_time_series={0.use_time_series}, "
            "validation_duration={0.validation_duration}, "
            "windows_basis_unit={0.windows_basis_unit}, "
        ).format(self)
