#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class FloatList(APIObject):
    """
    Attributes
    ----------
    max_length:int
         Maximum permitted length of the list.
    max_val:float
         Maximum permitted value.
    min_length:int
         Minimum permitted length of the list.
    min_val:float
         Minimum permitted value.
    supports_grid_search:bool
         When True, Grid Search is supported for this parameter.
    """
    _converter = t.Dict(
        {
            t.Key("max_length"):  t.Int(),
            t.Key("max_val"):  t.Float(),
            t.Key("min_length"):  t.Int(),
            t.Key("min_val"):  t.Float(),
            t.Key("supports_grid_search"):  t.Bool(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        max_length,
        max_val,
        min_length,
        min_val,
        supports_grid_search,
    ):
        self.max_length = max_length
        self.max_val = max_val
        self.min_length = min_length
        self.min_val = min_val
        self.supports_grid_search = supports_grid_search

    def __repr__(self):
        return (
            "FloatList("
            "max_length={0.max_length}, "
            "max_val={0.max_val}, "
            "min_length={0.min_length}, "
            "min_val={0.min_val}, "
            "supports_grid_search={0.supports_grid_search}, "
        ).format(self)
