#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class ForecastDate(APIObject):
    """
    Attributes
    ----------
    enabled:bool
         Indicates whether predictions by forecast dates is enabled for the deployment.
    column_name:str, none_type [optional]
         The column name in prediction datasets to be used as forecast date. 
    datetime_format:str, none_type [optional]
         The datetime format of the forecast date column in prediction datasets.. 
    """
    _converter = t.Dict(
        {
            t.Key("enabled"):  t.Bool(),
            t.Key("column_name", optional=True):  t.String(),
            t.Key("datetime_format", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        enabled,
        column_name=None,
        datetime_format=None,
    ):
        self.enabled = enabled
        self.column_name = column_name
        self.datetime_format = datetime_format

    def __repr__(self):
        return (
            "ForecastDate("
            "enabled={0.enabled}, "
            "column_name={0.column_name}, "
            "datetime_format={0.datetime_format}, "
        ).format(self)
