#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class ForecastDistancePlotDataEntryResponse(APIObject):
    """
    Attributes
    ----------
    backtesting_score:float, none_type
         Backtesting score for this forecast distance. If backtesting has not been run for this model, this score will be `null`.
    forecast_distance:int
         The number of time units the scored rows are away from the forecast point.
    holdout_score:float, none_type
         Holdout set score for this forecast distance. If holdout is locked for the project, this score will be `null`.
    validation_score:float
         Validation set score for this forecast distance.
    """
    _converter = t.Dict(
        {
            t.Key("backtesting_score"):  t.Float(),
            t.Key("forecast_distance"):  t.Int(),
            t.Key("holdout_score"):  t.Float(),
            t.Key("validation_score"):  t.Float(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        backtesting_score,
        forecast_distance,
        holdout_score,
        validation_score,
    ):
        self.backtesting_score = backtesting_score
        self.forecast_distance = forecast_distance
        self.holdout_score = holdout_score
        self.validation_score = validation_score

    def __repr__(self):
        return (
            "ForecastDistancePlotDataEntryResponse("
            "backtesting_score={0.backtesting_score}, "
            "forecast_distance={0.forecast_distance}, "
            "holdout_score={0.holdout_score}, "
            "validation_score={0.validation_score}, "
        ).format(self)
