#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.forecast_distance_plot_data_entry_response import ForecastDistancePlotDataEntryResponse

class ForecastDistanceStabilityPlotResponse(APIObject):
    """
    Attributes
    ----------
    end_date:datetime
         ISO-formatted start date of the project dataset.
    forecast_distance_plot_data:[ForecastDistancePlotDataEntryResponse]
         An array of objects containing the details of the scores for each forecast distance.
    metric_name:str
         Name of the metric used to compute the scores.
    start_date:datetime
         ISO-formatted start date of the project dataset.
    """
    _converter = t.Dict(
        {
            t.Key("end_date"):  t.DateTime(),
            t.Key("forecast_distance_plot_data"):  t.List(t.Dict().allow_extra("*")),
            t.Key("metric_name"):  t.String(),
            t.Key("start_date"):  t.DateTime(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        end_date,
        forecast_distance_plot_data,
        metric_name,
        start_date,
    ):
        self.end_date = end_date
        self.forecast_distance_plot_data = forecast_distance_plot_data
        self.metric_name = metric_name
        self.start_date = start_date

    def __repr__(self):
        return (
            "ForecastDistanceStabilityPlotResponse("
            "end_date={0.end_date}, "
            "forecast_distance_plot_data={0.forecast_distance_plot_data}, "
            "metric_name={0.metric_name}, "
            "start_date={0.start_date}, "
        ).format(self)
