#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class ForecastVsActualPlotsBins(APIObject):
    """
    Attributes
    ----------
    actual:float, none_type
         Average actual value of the target in the bin. `null` if there are no entries in the bin.
    end_date:datetime
         The datetime of the end of the bin (exclusive). 
    error:float, none_type
         Average absolute residual value of the bin. `null` if there are no entries in the bin.
    forecasts:[float]
         An array of average forecasts for the model for each forecast distance. Empty if there are no forecasts in the bin. Each index in the `forecasts` array maps to `forecastDistances` array index.
    frequency:int, none_type
         Indicates number of values averaged in bin in case of a resolution change.
    normalized_error:float, none_type
         Normalized average absolute residual value of the bin. `null` if there are no entries in the bin.
    start_date:datetime
         The datetime of the start of the bin (inclusive). 
    """
    _converter = t.Dict(
        {
            t.Key("actual"):  t.Float(),
            t.Key("end_date"):  t.DateTime(),
            t.Key("error"):  t.Float(),
            t.Key("forecasts"):  t.List(t.Dict().allow_extra("*")),
            t.Key("frequency"):  t.Int(),
            t.Key("normalized_error"):  t.Float(),
            t.Key("start_date"):  t.DateTime(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        actual,
        end_date,
        error,
        forecasts,
        frequency,
        normalized_error,
        start_date,
    ):
        self.actual = actual
        self.end_date = end_date
        self.error = error
        self.forecasts = forecasts
        self.frequency = frequency
        self.normalized_error = normalized_error
        self.start_date = start_date

    def __repr__(self):
        return (
            "ForecastVsActualPlotsBins("
            "actual={0.actual}, "
            "end_date={0.end_date}, "
            "error={0.error}, "
            "forecasts={0.forecasts}, "
            "frequency={0.frequency}, "
            "normalized_error={0.normalized_error}, "
            "start_date={0.start_date}, "
        ).format(self)
