#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.calendar_event import CalendarEvent
from datarobot.models.full_api.generated.model.forecast_vs_actual_plots_bins import ForecastVsActualPlotsBins

class ForecastVsActualPlotsDataResponse(APIObject):
    """
    Attributes
    ----------
    bins:[ForecastVsActualPlotsBins]
         An array of bins for the retrieved plots.
    calendar_events:[CalendarEvent]
         An array of calendar events for a retrieved plot.
    end_date:datetime
         The datetime of the end of the chart data (exclusive). 
    forecast_distances:[int]
         An array of forecast distances. Forecast distance specifies the number of time steps between the predicted point and the origin point.
    resolution:str
         The resolution that is used for binning.
    start_date:datetime
         The datetime of the start of the chart data (inclusive). 
    """
    _converter = t.Dict(
        {
            t.Key("bins"):  t.List(t.Dict().allow_extra("*")),
            t.Key("calendar_events"):  t.List(t.Dict().allow_extra("*")),
            t.Key("end_date"):  t.DateTime(),
            t.Key("forecast_distances"):  t.List(t.Dict().allow_extra("*")),
            t.Key("resolution"):  t.String(),
            t.Key("start_date"):  t.DateTime(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        bins,
        calendar_events,
        end_date,
        forecast_distances,
        resolution,
        start_date,
    ):
        self.bins = bins
        self.calendar_events = calendar_events
        self.end_date = end_date
        self.forecast_distances = forecast_distances
        self.resolution = resolution
        self.start_date = start_date

    def __repr__(self):
        return (
            "ForecastVsActualPlotsDataResponse("
            "bins={0.bins}, "
            "calendar_events={0.calendar_events}, "
            "end_date={0.end_date}, "
            "forecast_distances={0.forecast_distances}, "
            "resolution={0.resolution}, "
            "start_date={0.start_date}, "
        ).format(self)
