#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class FrequentValueData(APIObject):
    """
    Attributes
    ----------
    count:int
         Count of specified frequent value in the sample, weighted by exposure or weights
    data_quality:str
         Any data quality issue associated with this particularvalue of the feature. Possible data quality types include 'excess_zero', 'inlier', 'disguised_missing_value', and 'no_issues_found' and the relevant statistics.
    target:float
         Average target value for the specified frequent value if the target is binary or numeric. With weights or exposure, this becomes a weighted average. If the target is not set, it returns None.
    value:bool, date, datetime, dict, float, int, list, str, none_type
         Specified frequent value, either a float or a string, like `=All Others+`
    """
    _converter = t.Dict(
        {
            t.Key("count"):  t.Int(),
            t.Key("data_quality"):  t.String(),
            t.Key("target"):  t.Float(),
            t.Key("value"):  t.Any(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        count,
        data_quality,
        target,
        value,
    ):
        self.count = count
        self.data_quality = data_quality
        self.target = target
        self.value = value

    def __repr__(self):
        return (
            "FrequentValueData("
            "count={0.count}, "
            "data_quality={0.data_quality}, "
            "target={0.target}, "
            "value={0.value}, "
        ).format(self)
