#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.frequent_value_data import FrequentValueData

class FrequentValuesResponse(APIObject):
    """
    Attributes
    ----------
    frequent_values:[FrequentValueData]
         List of frequent value and data quality information
    name:str
         Name of the feature
    num_rows:int
         Number of rows in the sample used to determine frequent values
    project_id:str
         Project Id
    """
    _converter = t.Dict(
        {
            t.Key("frequent_values"):  t.List(t.Dict().allow_extra("*")),
            t.Key("name"):  t.String(),
            t.Key("num_rows"):  t.Int(),
            t.Key("project_id"):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        frequent_values,
        name,
        num_rows,
        project_id,
    ):
        self.frequent_values = frequent_values
        self.name = name
        self.num_rows = num_rows
        self.project_id = project_id

    def __repr__(self):
        return (
            "FrequentValuesResponse("
            "frequent_values={0.frequent_values}, "
            "name={0.name}, "
            "num_rows={0.num_rows}, "
            "project_id={0.project_id}, "
        ).format(self)
