#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class FromSpecific(APIObject):
    """
    Attributes
    ----------
    categories:bool, date, datetime, dict, float, int, list, str, none_type [optional]
         An array of strings describing the intended use of the dataset.. 
    credential_data:bool, date, datetime, dict, float, int, list, str, none_type [optional]
         The credentials to authenticate with the database, to be used instead of credential ID.. 
    credential_id:str [optional]
         The ID of the set of credentials to authenticate with the database.. 
    credentials:str [optional]
         A list of credentials to use if this is a Spark dataset that requires credentials.. 
    password:str [optional]
         The password (in cleartext) for database authentication. The password will be encrypted on the server-side HTTP request and never saved or stored. Required only if the previous data source was a data source. DEPRECATED: please use credentialId or credentialData instead.. 
    use_kerberos:bool [optional]
         If true, use Kerberos for database authentication..  if omitted the server will use the default value of False
    user:str [optional]
         The username for database authentication. Required only if the dataset was initially created from a data source. DEPRECATED: please use credentialId or credentialData instead.. 
    """
    _converter = t.Dict(
        {
            t.Key("categories", optional=True):  t.Any(),
            t.Key("credential_data", optional=True):  t.Any(),
            t.Key("credential_id", optional=True):  t.String(),
            t.Key("credentials", optional=True):  t.String(),
            t.Key("password", optional=True):  t.String(),
            t.Key("use_kerberos", optional=True):  t.Bool(),
            t.Key("user", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        categories=None,
        credential_data=None,
        credential_id=None,
        credentials=None,
        password=None,
        use_kerberos=None,
        user=None,
    ):
        self.categories = categories
        self.credential_data = credential_data
        self.credential_id = credential_id
        self.credentials = credentials
        self.password = password
        self.use_kerberos = use_kerberos
        self.user = user

    def __repr__(self):
        return (
            "FromSpecific("
            "categories={0.categories}, "
            "credential_data={0.credential_data}, "
            "credential_id={0.credential_id}, "
            "credentials={0.credentials}, "
            "password={0.password}, "
            "use_kerberos={0.use_kerberos}, "
            "user={0.user}, "
        ).format(self)
