#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class FrozenModelCreate(APIObject):
    """
    Attributes
    ----------
    model_id:str
         the ID of an existing model to use as a source of training parameters.
    sample_pct:float [optional]
         the percentage of the dataset to use with the model. Only one of `samplePct` and `trainingRowCount` should be specified. The specified percentage should be between 0.0 and 100.0.. 
    training_row_count:int [optional]
         the integer number of rows of the dataset to use with the model. Only one of `samplePct` and `trainingRowCount` should be specified.. 
    """
    _converter = t.Dict(
        {
            t.Key("model_id"):  t.String(),
            t.Key("sample_pct", optional=True):  t.Float(),
            t.Key("training_row_count", optional=True):  t.Int(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        model_id,
        sample_pct=None,
        training_row_count=None,
    ):
        self.model_id = model_id
        self.sample_pct = sample_pct
        self.training_row_count = training_row_count

    def __repr__(self):
        return (
            "FrozenModelCreate("
            "model_id={0.model_id}, "
            "sample_pct={0.sample_pct}, "
            "training_row_count={0.training_row_count}, "
        ).format(self)
