#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.entity_count_by_type_response import EntityCountByTypeResponse
from datarobot.models.full_api.generated.model.feature_count_by_type_response import FeatureCountByTypeResponse
from datarobot.models.full_api.generated.model.time_series_properties import TimeSeriesProperties

class FullDatasetDetailsResponse(APIObject):
    """
    Attributes
    ----------
    categories:[str]
         An array of strings describing the intended use of the dataset.
    created_by:str
         Username of the user who created the dataset.
    creation_date:datetime
         The date when the dataset was created.
    data_engine_query_id:str, none_type
         ID of the source data engine query.
    data_persisted:bool
         If true, user is allowed to view extended data profile (which includes data statistics like min/max/median/mean, histogram, etc.) and download data. If false, download is not allowed and only the data schema (feature names and types) will be available.
    data_source_id:str, none_type
         ID of the datasource used as the source of the dataset.
    data_source_type:str
         The type of the datasource that was used as the source of the dataset.
    dataset_id:str
         The ID of this dataset.
    dataset_size:int
         The size of the dataset as a CSV in bytes.
    description:str, none_type
         The description of the dataset.
    eda1_modification_date:datetime
         The ISO 8601 formatted date and time when the EDA1 for the dataset was updated.
    eda1_modifier_full_name:str
         The user who was the last to update EDA1 for the dataset.
    error:str
         Details of exception raised during ingestion process, if any.
    feature_count:int
         Total number of features in the dataset.
    feature_count_by_type:[FeatureCountByTypeResponse]
         Number of features in the dataset grouped by feature type.
    is_data_engine_eligible:bool
         Whether this dataset can be a data source of a data engine query.
    is_latest_version:bool
         Whether this dataset version is the latest version of this dataset.
    is_snapshot:bool
         Whether the dataset is an immutable snapshot of data which has previously been retrieved and saved to DataRobot.
    last_modification_date:datetime
         The ISO 8601 formatted date and time when the dataset was last modified.
    last_modifier_full_name:str
         Full name of user who was the last to modify the dataset.
    name:str
         The name of this dataset in the catalog.
    processing_state:str
         Current ingestion process state of dataset.
    row_count:int
         The number of rows in the dataset.
    tags:[str]
         List of tags attached to the item.
    time_series_properties:TimeSeriesProperties
        
    uri:str
         The URI to datasource. For example, `file_name.csv`, or `jdbc:DATA_SOURCE_GIVEN_NAME/SCHEMA.TABLE_NAME`, or `jdbc:DATA_SOURCE_GIVEN_NAME/<query>` for `query` based datasources, or`https://s3.amazonaws.com/datarobot_test/kickcars-sample-200.csv`, etc.
    version_id:str
         The object ID of the catalog_version the dataset belongs to.
    entity_count_by_type:EntityCountByTypeResponse [optional]
         
    """
    _converter = t.Dict(
        {
            t.Key("categories"):  t.List(t.Dict().allow_extra("*")),
            t.Key("created_by"):  t.String(),
            t.Key("creation_date"):  t.DateTime(),
            t.Key("data_engine_query_id"):  t.String(),
            t.Key("data_persisted"):  t.Bool(),
            t.Key("data_source_id"):  t.String(),
            t.Key("data_source_type"):  t.String(),
            t.Key("dataset_id"):  t.String(),
            t.Key("dataset_size"):  t.Int(),
            t.Key("description"):  t.String(),
            t.Key("eda1_modification_date"):  t.DateTime(),
            t.Key("eda1_modifier_full_name"):  t.String(),
            t.Key("error"):  t.String(),
            t.Key("feature_count"):  t.Int(),
            t.Key("feature_count_by_type"):  t.List(t.Dict().allow_extra("*")),
            t.Key("is_data_engine_eligible"):  t.Bool(),
            t.Key("is_latest_version"):  t.Bool(),
            t.Key("is_snapshot"):  t.Bool(),
            t.Key("last_modification_date"):  t.DateTime(),
            t.Key("last_modifier_full_name"):  t.String(),
            t.Key("name"):  t.String(),
            t.Key("processing_state"):  t.String(),
            t.Key("row_count"):  t.Int(),
            t.Key("tags"):  t.List(t.Dict().allow_extra("*")),
            t.Key("time_series_properties"):  t.Any(),
            t.Key("uri"):  t.String(),
            t.Key("version_id"):  t.String(),
            t.Key("entity_count_by_type", optional=True):  t.Any(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        categories,
        created_by,
        creation_date,
        data_engine_query_id,
        data_persisted,
        data_source_id,
        data_source_type,
        dataset_id,
        dataset_size,
        description,
        eda1_modification_date,
        eda1_modifier_full_name,
        error,
        feature_count,
        feature_count_by_type,
        is_data_engine_eligible,
        is_latest_version,
        is_snapshot,
        last_modification_date,
        last_modifier_full_name,
        name,
        processing_state,
        row_count,
        tags,
        time_series_properties,
        uri,
        version_id,
        entity_count_by_type=None,
    ):
        self.categories = categories
        self.created_by = created_by
        self.creation_date = creation_date
        self.data_engine_query_id = data_engine_query_id
        self.data_persisted = data_persisted
        self.data_source_id = data_source_id
        self.data_source_type = data_source_type
        self.dataset_id = dataset_id
        self.dataset_size = dataset_size
        self.description = description
        self.eda1_modification_date = eda1_modification_date
        self.eda1_modifier_full_name = eda1_modifier_full_name
        self.error = error
        self.feature_count = feature_count
        self.feature_count_by_type = feature_count_by_type
        self.is_data_engine_eligible = is_data_engine_eligible
        self.is_latest_version = is_latest_version
        self.is_snapshot = is_snapshot
        self.last_modification_date = last_modification_date
        self.last_modifier_full_name = last_modifier_full_name
        self.name = name
        self.processing_state = processing_state
        self.row_count = row_count
        self.tags = tags
        self.time_series_properties = time_series_properties
        self.uri = uri
        self.version_id = version_id
        self.entity_count_by_type = entity_count_by_type

    def __repr__(self):
        return (
            "FullDatasetDetailsResponse("
            "categories={0.categories}, "
            "created_by={0.created_by}, "
            "creation_date={0.creation_date}, "
            "data_engine_query_id={0.data_engine_query_id}, "
            "data_persisted={0.data_persisted}, "
            "data_source_id={0.data_source_id}, "
            "data_source_type={0.data_source_type}, "
            "dataset_id={0.dataset_id}, "
            "dataset_size={0.dataset_size}, "
            "description={0.description}, "
            "eda1_modification_date={0.eda1_modification_date}, "
            "eda1_modifier_full_name={0.eda1_modifier_full_name}, "
            "error={0.error}, "
            "feature_count={0.feature_count}, "
            "feature_count_by_type={0.feature_count_by_type}, "
            "is_data_engine_eligible={0.is_data_engine_eligible}, "
            "is_latest_version={0.is_latest_version}, "
            "is_snapshot={0.is_snapshot}, "
            "last_modification_date={0.last_modification_date}, "
            "last_modifier_full_name={0.last_modifier_full_name}, "
            "name={0.name}, "
            "processing_state={0.processing_state}, "
            "row_count={0.row_count}, "
            "tags={0.tags}, "
            "time_series_properties={0.time_series_properties}, "
            "uri={0.uri}, "
            "version_id={0.version_id}, "
            "entity_count_by_type={0.entity_count_by_type}, "
        ).format(self)
