#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class GCPKey(APIObject):
    """
    Attributes
    ----------
    type:str
         GCP account type.. defaults to "service_account", must be one of ["service_account", ]
    auth_provider_x509_cert_url:str [optional]
         Auth provider X509 certificate URL.. 
    auth_uri:str [optional]
         Auth URI.. 
    client_email:str [optional]
         Client email address.. 
    client_id:str [optional]
         Client ID.. 
    client_x509_cert_url:str [optional]
         Client X509 certificate URL.. 
    private_key:str [optional]
         Private key.. 
    private_key_id:str [optional]
         Private key ID. 
    project_id:str [optional]
         Project ID.. 
    token_uri:str [optional]
         Token URI.. 
    """
    _converter = t.Dict(
        {
            t.Key("type"):  t.String(),
            t.Key("auth_provider_x509_cert_url", optional=True):  t.String(),
            t.Key("auth_uri", optional=True):  t.String(),
            t.Key("client_email", optional=True):  t.String(),
            t.Key("client_id", optional=True):  t.String(),
            t.Key("client_x509_cert_url", optional=True):  t.String(),
            t.Key("private_key", optional=True):  t.String(),
            t.Key("private_key_id", optional=True):  t.String(),
            t.Key("project_id", optional=True):  t.String(),
            t.Key("token_uri", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        type,
        auth_provider_x509_cert_url=None,
        auth_uri=None,
        client_email=None,
        client_id=None,
        client_x509_cert_url=None,
        private_key=None,
        private_key_id=None,
        project_id=None,
        token_uri=None,
    ):
        self.type = type
        self.auth_provider_x509_cert_url = auth_provider_x509_cert_url
        self.auth_uri = auth_uri
        self.client_email = client_email
        self.client_id = client_id
        self.client_x509_cert_url = client_x509_cert_url
        self.private_key = private_key
        self.private_key_id = private_key_id
        self.project_id = project_id
        self.token_uri = token_uri

    def __repr__(self):
        return (
            "GCPKey("
            "type={0.type}, "
            "auth_provider_x509_cert_url={0.auth_provider_x509_cert_url}, "
            "auth_uri={0.auth_uri}, "
            "client_email={0.client_email}, "
            "client_id={0.client_id}, "
            "client_x509_cert_url={0.client_x509_cert_url}, "
            "private_key={0.private_key}, "
            "private_key_id={0.private_key_id}, "
            "project_id={0.project_id}, "
            "token_uri={0.token_uri}, "
        ).format(self)
