#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.geo_feature_plot_feature import GeoFeaturePlotFeature
from datarobot.models.full_api.generated.model.geo_feature_plot_summary import GeoFeaturePlotSummary

class GeoFeaturePlotData(APIObject):
    """
    Attributes
    ----------
    aggregation:str
         Type of geo aggregation.
    bbox:{str: (bool, date, datetime, dict, float, int, list, str, none_type)}
         Bounding box of feature map.
    features:[GeoFeaturePlotFeature]
         Location features over map
    summary:GeoFeaturePlotSummary
        
    type:str
         GeoJSON FeatureCollection.
    value_aggregation:str
         Type of feature aggregation.. defaults to "geometry", must be one of ["geometry", ]
    """
    _converter = t.Dict(
        {
            t.Key("aggregation"):  t.String(),
            t.Key("bbox"):  t.Any(),
            t.Key("features"):  t.List(t.Dict().allow_extra("*")),
            t.Key("summary"):  t.Any(),
            t.Key("type"):  t.String(),
            t.Key("value_aggregation"):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        aggregation,
        bbox,
        features,
        summary,
        type,
        value_aggregation,
    ):
        self.aggregation = aggregation
        self.bbox = bbox
        self.features = features
        self.summary = summary
        self.type = type
        self.value_aggregation = value_aggregation

    def __repr__(self):
        return (
            "GeoFeaturePlotData("
            "aggregation={0.aggregation}, "
            "bbox={0.bbox}, "
            "features={0.features}, "
            "summary={0.summary}, "
            "type={0.type}, "
            "value_aggregation={0.value_aggregation}, "
        ).format(self)
