#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class GeoFeaturePlotSummary(APIObject):
    """
    Attributes
    ----------
    max_count:int
         Max num of samples located within one geometry.
    min_count:int
         Min num of samples located within one geometry.
    total_count:int
         Total num of samples across all geometry objects.
    """
    _converter = t.Dict(
        {
            t.Key("max_count"):  t.Int(),
            t.Key("min_count"):  t.Int(),
            t.Key("total_count"):  t.Int(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        max_count,
        min_count,
        total_count,
    ):
        self.max_count = max_count
        self.min_count = min_count
        self.total_count = total_count

    def __repr__(self):
        return (
            "GeoFeaturePlotSummary("
            "max_count={0.max_count}, "
            "min_count={0.min_count}, "
            "total_count={0.total_count}, "
        ).format(self)
