#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.geo_feature_plot_data import GeoFeaturePlotData

class GeometryFeaturePlotRetrieveResponse(APIObject):
    """
    Attributes
    ----------
    feature:str
         Name of location feature to plot on map.
    plot_data:GeoFeaturePlotData
        
    project_id:str
         The project to select a location feature from.
    """
    _converter = t.Dict(
        {
            t.Key("feature"):  t.String(),
            t.Key("plot_data"):  t.Any(),
            t.Key("project_id"):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        feature,
        plot_data,
        project_id,
    ):
        self.feature = feature
        self.plot_data = plot_data
        self.project_id = project_id

    def __repr__(self):
        return (
            "GeometryFeaturePlotRetrieveResponse("
            "feature={0.feature}, "
            "plot_data={0.plot_data}, "
            "project_id={0.project_id}, "
        ).format(self)
