#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class GrantAccessControlWithUsernameWithGrant(APIObject):
    """
    Attributes
    ----------
    role:str
         The role of the recipient on this entity. One of OWNER, USER, OBSERVER.
    share_recipient_type:str
         Describes the recipient type, either user, group, or organization.
    username:str
         Username of the user to update the access role for.
    can_share:bool [optional]
         Whether the org/group/user should be able to share with others.If true, the org/group/user will be able to grant any role up to and includingtheir own to other orgs/groups/user. If `role` is `NO_ROLE` `canShare` is ignored..  if omitted the server will use the default value of True
    """
    _converter = t.Dict(
        {
            t.Key("role"):  t.String(),
            t.Key("share_recipient_type"):  t.String(),
            t.Key("username"):  t.String(),
            t.Key("can_share", optional=True):  t.Bool(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        role,
        share_recipient_type,
        username,
        can_share=None,
    ):
        self.role = role
        self.share_recipient_type = share_recipient_type
        self.username = username
        self.can_share = can_share

    def __repr__(self):
        return (
            "GrantAccessControlWithUsernameWithGrant("
            "role={0.role}, "
            "share_recipient_type={0.share_recipient_type}, "
            "username={0.username}, "
            "can_share={0.can_share}, "
        ).format(self)
