#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class Hdfs(APIObject):
    """
    Attributes
    ----------
    url:str
         The HDFS url to use as the source of data for the dataset being created.
    categories:bool, date, datetime, dict, float, int, list, str, none_type [optional]
         An array of strings describing the intended use of the dataset.. 
    do_snapshot:bool [optional]
         If true, create a snapshot dataset; if false, create a remote dataset. Creating snapshots from non-file sources requires an additional permission, `Enable Create Snapshot Data Source`..  if omitted the server will use the default value of True
    namenode_webhdfs_port:int [optional]
         The port of HDFS name node.. 
    password:str [optional]
         The password (in cleartext) for authenticating to HDFS using Kerberos. The password will be encrypted on the server side in scope of HTTP request and never saved or stored.. 
    persist_data_after_ingestion:bool [optional]
         If true, will enforce saving all data (for download and sampling) and will allow a user to view extended data profile (which includes data statistics like min/max/median/mean, histogram, etc.). If false, will not enforce saving data. The data schema (feature names and types) still will be available. Specifying this parameter to false and `doSnapshot` to true will result in an error. 
    user:str [optional]
         The username for authenticating to HDFS using Kerberos.. 
    """
    _converter = t.Dict(
        {
            t.Key("url"):  t.String(),
            t.Key("categories", optional=True):  t.Any(),
            t.Key("do_snapshot", optional=True):  t.Bool(),
            t.Key("namenode_webhdfs_port", optional=True):  t.Int(),
            t.Key("password", optional=True):  t.String(),
            t.Key("persist_data_after_ingestion", optional=True):  t.Bool(),
            t.Key("user", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        url,
        categories=None,
        do_snapshot=None,
        namenode_webhdfs_port=None,
        password=None,
        persist_data_after_ingestion=None,
        user=None,
    ):
        self.url = url
        self.categories = categories
        self.do_snapshot = do_snapshot
        self.namenode_webhdfs_port = namenode_webhdfs_port
        self.password = password
        self.persist_data_after_ingestion = persist_data_after_ingestion
        self.user = user

    def __repr__(self):
        return (
            "Hdfs("
            "url={0.url}, "
            "categories={0.categories}, "
            "do_snapshot={0.do_snapshot}, "
            "namenode_webhdfs_port={0.namenode_webhdfs_port}, "
            "password={0.password}, "
            "persist_data_after_ingestion={0.persist_data_after_ingestion}, "
            "user={0.user}, "
        ).format(self)
