#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class HdfsProjectCreate(APIObject):
    """
    Attributes
    ----------
    url:str
         URL of the WebHDFS resource. Represent the file using the `hdfs://` protocol marker (for example,  `hdfs:///tmp/somedataset.csv`).
    password:str [optional]
         Password for authenticating to HDFS using Kerberos. The password will be encrypted on the server side in scope of HTTP request and never saved or stored.. 
    port:int [optional]
         Port of the WebHDFS Namenode server. If not specified, defaults to HDFS default port 50070.. 
    project_name:str [optional]
         Name of the project to be created. If not specified, project name will be based on the file name.. 
    user:str [optional]
         Username for authenticating to HDFS using Kerberos. 
    """
    _converter = t.Dict(
        {
            t.Key("url"):  t.String(),
            t.Key("password", optional=True):  t.String(),
            t.Key("port", optional=True):  t.Int(),
            t.Key("project_name", optional=True):  t.String(),
            t.Key("user", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        url,
        password=None,
        port=None,
        project_name=None,
        user=None,
    ):
        self.url = url
        self.password = password
        self.port = port
        self.project_name = project_name
        self.user = user

    def __repr__(self):
        return (
            "HdfsProjectCreate("
            "url={0.url}, "
            "password={0.password}, "
            "port={0.port}, "
            "project_name={0.project_name}, "
            "user={0.user}, "
        ).format(self)
