#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class HTTPOutput(APIObject):
    """
    Attributes
    ----------
    method:str
         Method to use when saving the CSV file
    type:str
         Type name for this output type. defaults to "http", must be one of ["http", ]
    url:str
         URL for the CSV file
    headers:{str: (bool, date, datetime, dict, float, int, list, str, none_type)} [optional]
         Extra headers to send with the request. 
    """
    _converter = t.Dict(
        {
            t.Key("method"):  t.String(),
            t.Key("type"):  t.String(),
            t.Key("url"):  t.String(),
            t.Key("headers", optional=True):  t.Any(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        method,
        type,
        url,
        headers=None,
    ):
        self.method = method
        self.type = type
        self.url = url
        self.headers = headers

    def __repr__(self):
        return (
            "HTTPOutput("
            "method={0.method}, "
            "type={0.type}, "
            "url={0.url}, "
            "headers={0.headers}, "
        ).format(self)
