#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.humility_stats_bucket import HumilityStatsBucket

class HumilityStatsOverTimeRetrieveResponse(APIObject):
    """
    Attributes
    ----------
    buckets:[HumilityStatsBucket]
         An array of `bucket` objects, representing service health stats of the deployment over time
    summary:HumilityStatsBucket
        
    model_id:str [optional]
         The id of the model for which metrics are being retrieved.. 
    segment_attribute:str, none_type [optional]
         The name of the segment on which segment analysis is being performed.. 
    segment_value:str, none_type [optional]
         The value of the `segmentAttribute` to segment on..  if omitted the server will use the default value of ""
    """
    _converter = t.Dict(
        {
            t.Key("buckets"):  t.List(t.Dict().allow_extra("*")),
            t.Key("summary"):  t.Any(),
            t.Key("model_id", optional=True):  t.String(),
            t.Key("segment_attribute", optional=True):  t.String(),
            t.Key("segment_value", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        buckets,
        summary,
        model_id=None,
        segment_attribute=None,
        segment_value=None,
    ):
        self.buckets = buckets
        self.summary = summary
        self.model_id = model_id
        self.segment_attribute = segment_attribute
        self.segment_value = segment_value

    def __repr__(self):
        return (
            "HumilityStatsOverTimeRetrieveResponse("
            "buckets={0.buckets}, "
            "summary={0.summary}, "
            "model_id={0.model_id}, "
            "segment_attribute={0.segment_attribute}, "
            "segment_value={0.segment_value}, "
        ).format(self)
