#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class HyperparametersResponse(APIObject):
    """
    Attributes
    ----------
    building_blocks:{str: (bool, date, datetime, dict, float, int, list, str, none_type)}, none_type
         Mathematical operators and other components that comprise Eureqa Expressions.
    max_generations:int, none_type
         The maximum number of evolutionary generations to run.
    num_threads:int, none_type
         The number of threads Eureqa will run with.
    prior_solutions:[str], none_type
         Prior Eureqa Solutions.
    random_seed:int, none_type
         Constant to seed Eureqa's pseudo-random number generator.
    split_mode:str, none_type
         Whether to perform in-order (2) or random (1) splitting within the training set, for evolutionary re-training and re-validatoon.
    sync_migrations:bool, none_type
         Whether Eureqa's migrations are synchronized.
    target_expression_format:str, none_type
         Constrain the target expression to the specified format.
    target_expression_string:str, none_type
         Eureqa Expression to constrain the form of the models that Eureqa will consider.
    timeout_sec:float, none_type
         The duration of time to run the Eureqa search algorithm for Eureqa will run until either of max_generations or timeout_sec is reached.
    training_fraction:float, none_type
         The fraction of the DataRobot training data to use for Eureqa evolutionary training.
    training_split_expr:str, none_type
         Valid Eureqa Expression to do Eureqa internal training splits.
    validation_fraction:float, none_type
         The fraction of the DataRobot training data to use for Eureqa evolutionary validation.
    validation_split_expr:str, none_type
         Valid Eureqa Expression to do Eureqa internal validation splits.
    weight_expr:str, none_type
         Eureqa Weight Expression.
    error_metric:str, none_type [optional]
         Error Metric Eureqa used internally, to evaluate which models to keep on its internal Pareto Front. . 
    """
    _converter = t.Dict(
        {
            t.Key("building_blocks"):  t.Any(),
            t.Key("max_generations"):  t.Int(),
            t.Key("num_threads"):  t.Int(),
            t.Key("prior_solutions"):  t.List(t.Dict().allow_extra("*")),
            t.Key("random_seed"):  t.Int(),
            t.Key("split_mode"):  t.String(),
            t.Key("sync_migrations"):  t.Bool(),
            t.Key("target_expression_format"):  t.String(),
            t.Key("target_expression_string"):  t.String(),
            t.Key("timeout_sec"):  t.Float(),
            t.Key("training_fraction"):  t.Float(),
            t.Key("training_split_expr"):  t.String(),
            t.Key("validation_fraction"):  t.Float(),
            t.Key("validation_split_expr"):  t.String(),
            t.Key("weight_expr"):  t.String(),
            t.Key("error_metric", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        building_blocks,
        max_generations,
        num_threads,
        prior_solutions,
        random_seed,
        split_mode,
        sync_migrations,
        target_expression_format,
        target_expression_string,
        timeout_sec,
        training_fraction,
        training_split_expr,
        validation_fraction,
        validation_split_expr,
        weight_expr,
        error_metric=None,
    ):
        self.building_blocks = building_blocks
        self.max_generations = max_generations
        self.num_threads = num_threads
        self.prior_solutions = prior_solutions
        self.random_seed = random_seed
        self.split_mode = split_mode
        self.sync_migrations = sync_migrations
        self.target_expression_format = target_expression_format
        self.target_expression_string = target_expression_string
        self.timeout_sec = timeout_sec
        self.training_fraction = training_fraction
        self.training_split_expr = training_split_expr
        self.validation_fraction = validation_fraction
        self.validation_split_expr = validation_split_expr
        self.weight_expr = weight_expr
        self.error_metric = error_metric

    def __repr__(self):
        return (
            "HyperparametersResponse("
            "building_blocks={0.building_blocks}, "
            "max_generations={0.max_generations}, "
            "num_threads={0.num_threads}, "
            "prior_solutions={0.prior_solutions}, "
            "random_seed={0.random_seed}, "
            "split_mode={0.split_mode}, "
            "sync_migrations={0.sync_migrations}, "
            "target_expression_format={0.target_expression_format}, "
            "target_expression_string={0.target_expression_string}, "
            "timeout_sec={0.timeout_sec}, "
            "training_fraction={0.training_fraction}, "
            "training_split_expr={0.training_split_expr}, "
            "validation_fraction={0.validation_fraction}, "
            "validation_split_expr={0.validation_split_expr}, "
            "weight_expr={0.weight_expr}, "
            "error_metric={0.error_metric}, "
        ).format(self)
